package fr.asip.cps3.exemple.vues.menus;

import java.awt.event.ActionListener;
import fr.asip.cps3.exemple.modele.objets.Objet;

/**
 * Classe modlisant un item de menu de type Objet
 *
 */
public class ItemMenuObjet extends ItemMenu {
	
	private static final long serialVersionUID = -2677514472376816015L;
	
	/**
	 * Objet associ  l'item de menu
	 */
	private Objet objet;

	/**
	 * Constructeur  5 arguments 
	 * @param objet Objet associ  l'item de menu
	 * @param idParent Identifiant du menu parent
	 * @param enable Boolen attestant du caractre actionnable de l'item de menu
	 * @param visible Boolen attestant du caractre visible de l'item de menu
	 * @param ecouteur Ecouteur positionn sur l'item de menu
	 */
	public ItemMenuObjet(Objet objet,String idParent, boolean enable, boolean visible, ActionListener ecouteur) {
		
		super(idParent+",", idParent, "", enable, visible, ecouteur);
		this.objet = objet;
		if(objet != null) {
			setId(getIdParent()+","+objet.getIdObjet());
			setText(objet.getLibelle());
		}
		
	}

	/**
	 * Accesseur
	 * @return Objet associ  l'item de menu
	 */
	public Objet getObjet() {
		return objet;
	}


	
}
